function checkRelations(force1, force2)
	log("relations", ">>>>>", force1, "	", force2)
	if(isValid(force1) and isValid(force2)) then
		local result1 = Forces[force1][force2]
		local result2 = Forces[force2][force1]
	
		if (result1 ~= result2) then
			log("relations", ": ",force1,"  ",force2," - ",result1)
			log("relations", "a: ",force2,"  ",force1," - ",result2)
			log("relations", ": ",result2)
			return result2
		end
		return result1
	end
	return(NEUTRAL)
end

function setRelations(we, treat_them, as_relation)

	Forces[we][treat_them] = as_relation
	Forces[treat_them][we] = as_relation
	
	if (treat_them == PLAYER) then
		if (as_relation == ENEMY) then
			Reputation[we] = Reputation.MIN
			if(we==MARAUDERS) then
				setGVAR("ALLIANCE_WITH_MARAUDERS",_NO)
				setGVAR("WAR_WITH_MARAUDERS", _YES)
			elseif(we==BUTSI) then
				setGVAR("ALLIANCE_WITH_BUTSI",_NO)
				setGVAR("WAR_WITH_BUTSI", _YES)
			end		
		elseif (as_relation == NEUTRAL) then
			Reputation[we] = 0.5 * (Reputation.MAX - Reputation.MIN) + Reputation.MIN
		else
			Reputation[we] = Reputation.MAX
			if(we==MARAUDERS) then
				setGVAR("ALLIANCE_WITH_MARAUDERS",_YES)
				setGVAR("WAR_WITH_MARAUDERS", _NO)
			elseif(we==BUTSI) then
				setGVAR("ALLIANCE_WITH_BUTSI",_YES)
				setGVAR("WAR_WITH_BUTSI", _NO)
			end
		end
	end
end

-- not used
function updateForces()

	local update = function(force, repa)
		
		if ((force ~= "Costs") and (force ~= "MIN") and (force ~= "MAX") and (force ~= "Bonus") and (force ~= "Penalty")) then
		
			local relation = checkRelations(force, PLAYER)
			local new_relation = relation
			local rnd = math.random()
			local plank = 0
			local log_id = "reputation_system"
			local repa0		= Reputation.MIN
			local repa20 	= 0.2 * (Reputation.MAX - Reputation.MIN) + Reputation.MIN
			local repa30 	= 0.3 * (Reputation.MAX - Reputation.MIN) + Reputation.MIN
			local repa50 	= 0.5 * (Reputation.MAX - Reputation.MIN) + Reputation.MIN
			local repa70 	= 0.7 * (Reputation.MAX - Reputation.MIN) + Reputation.MIN
			local repa80 	= 0.8 * (Reputation.MAX - Reputation.MIN) + Reputation.MIN
			local repa100	= Reputation.MAX
	
			if ((repa <= repa20 ) and (relation ~= ENEMY)) then
				log(log_id, "UPDATE","   201      ")
				--    201      
				--      
				plank = repa/repa20			
				
				log(log_id, ">>","Plank:", plank)
				log(log_id, ">>","Random:", rnd)
				
				new_relation = ENEMY
				
				log(log_id, ">>","r:", relation, "new_r:", new_relation)
			end
			
			if ((repa >= repa30) and (relation == ENEMY)) then
				log(log_id, "UPDATE","   299     ")
				--    299     
				--      
				plank = (repa50 - repa)/repa20 	
				
				log(log_id, ">>","Plank:", plank)
				log(log_id, ">>","Random:", rnd)
				
				new_relation = NEUTRAL
				
				log(log_id, ">>","r:", relation, "new_r:", new_relation)
			end
			
			if ((repa <= repa70) and (relation == ALLY)) then
				log(log_id, "UPDATE","   701     ")
				--    701     
				--      
				plank = (repa - repa50)/repa20 	
				
				log(log_id, ">>","Plank:", plank)
				log(log_id, ">>","Random:", rnd)
				
				new_relation = NEUTRAL
				
				log(log_id, ">>","r:", relation, "new_r:", new_relation)
			end
			
			if ((repa >= repa80) and (relation ~= ALLY)) then
				log(log_id, "UPDATE","   799      ")
				--    799      
				--      
				plank = (repa100 - repa)/repa20	
				log(log_id, ">>","Plank:", plank)
				log(log_id, ">>","Random:", rnd)
				new_relation = ALLY
				log(log_id, ">>","r:", relation, "new_r:", new_relation)
			end
	
			if ((rnd >= plank) and (new_relation ~= relation)) then
				setRelations(force, PLAYER, new_relation)
				log(log_id, "UPDATE",force,"thinks that Player is",new_relation)
				log(log_id, "UPDATE","Player thinks that",force,"is",new_relation)
			end
		end
	end
	
	table.foreach(Reputation, update)
end

function addReputation(who, rep)
	log("diplomacy", "_WAS Reputation", who, Reputation[who] )
	Reputation[who] = Reputation[who] + rep
	
	if Reputation[who] < Reputation.MIN then Reputation[who] = Reputation.MIN end
	if Reputation[who] > Reputation.MAX then Reputation[who] = Reputation.MAX end
	
--	updateForces()
end

-- not used
function setupLocalRelations(global_force1, local_clan1, global_force2, local_clan2)
	if nil == global_force2 then global_force2 = PLAYER end
	if nil == local_clan2 then local_clan2 = "mercs" end

	local result = checkRelations(global_force1, global_force2)
	
	relationsChange(local_clan2, local_clan1, result)
	relationsChange(local_clan1, local_clan2, result)
end

function changeLocalRelations(state, local_clan1,local_clan2)
	if ( nil == local_clan2 ) then 
		local_clan2 = PLAYER 
	end
	relationsChange(local_clan2, local_clan1, state)
	relationsChange(local_clan1, local_clan2, state)
	if(state==ALLY) then
		
		local removeKnownAndVisibleForTeam = function(id,id_clan,ally_clan)
			if(id_clan==team(id)) then
				memory.removeKnownEnemyFromTeam(ally_clan,id)
				service.removeFromVisibleTeam(ally_clan,id)
			end
		end

		local removeKnownAndVisible = function(index,value)
			removeKnownAndVisibleForTeam(index,local_clan1,local_clan2)
			removeKnownAndVisibleForTeam(index,local_clan2,local_clan1)
		end

		table.foreach(Humans,removeKnownAndVisible)
	end
end

-- not used
function checkReputation(force1, force2)
	if nil == force2 then force2 = PLAYER end
	local result1 = Forces[force1][force2]
	local result2 = Forces[force2][force1]
	
	if (result1 ~= result2) then
		log("relations", ": "..force1.."  "..force2.." - "..result1)
		log("relations", "a: "..force2.."  "..force1.." - "..result2)
		return result1
	end
	
	return result1
end

-- not used
function updateReputationLevel(arg)

	local repa0		= Reputation.MIN
	local repa40 	= 0.4 * (Reputation.MAX - Reputation.MIN) + Reputation.MIN
	local repa60 	= 0.6 * (Reputation.MAX - Reputation.MIN) + Reputation.MIN
	local repa90 	= 0.9 * (Reputation.MAX - Reputation.MIN) + Reputation.MIN
	local repa100	= Reputation.MAX
			
	if nil == arg then
		return
	end

	if BUTSI == arg then
		local rep = Reputation[BUTSI]
		if rep > repa0 and rep <= repa40 then
			setGVAR("BUTSI_RELATION_LEVEL", 0) --UNFRIENDLY
		elseif rep > repa40 and rep <= repa60 then
			setGVAR("BUTSI_RELATION_LEVEL", 1) --NEUTRAL
		elseif rep > repa60 and rep <= repa90 then
			setGVAR("BUTSI_RELATION_LEVEL", 2) --FRIENDLY
		else
			setGVAR("BUTSI_RELATION_LEVEL", 3)	--ALLY
		end
	end

	if MARAUDERS == arg then
		local rep = Reputation[MARAUDERS]
		if rep > repa0 and rep <= repa40 then
			setGVAR("MARAUDERS_RELATION_LEVEL", 0) --UNFRIENDLY
		elseif rep > repa40 and rep <= repa60 then
			setGVAR("MARAUDERS_RELATION_LEVEL", 1) --NEUTRAL
		elseif rep > repa60 and rep <= repa90 then
			setGVAR("MARAUDERS_RELATION_LEVEL", 2) --FRIENDLY
		else
			setGVAR("MARAUDERS_RELATION_LEVEL", 3)	--ALLY
		end
	end


end

function complexReputationChange(force, reason)
	local amount = 0
	local cost = 0
	local resonance = true
	local log_id = "reputation_system"
	
	log(log_id, ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	log(log_id, "entrance", "force:", force, "reason:", reason)
	
	if not(isValid(force)) then
		log(log_id, "error", "wrong incoming force")
		return
	end

	local cr = Reputation[force]
	local rel = checkRelations(force, PLAYER)

	if not(isValid(cr)) then
		log(log_id, "error", "wrong reputation force")
		return
	end

	log(log_id, "Current reputation:", cr, "Relations:", rel)
	
	if (reason == "KILLED") then
		cost = Reputation.Costs.Killed
		
		if (rel == ENEMY) then
			amount = -3 * cost
		elseif (rel == NEUTRAL) then
			amount = -2 * cost
		else
			amount = -1 * cost
		end
	elseif (reason == "WOUNDED") then
		cost = Reputation.Costs.Wounded
		resonance = false
		
		if (rel == ENEMY) then
			amount = -2 * cost
		elseif (rel == NEUTRAL) then
			amount = -1.5 * cost
		else
			amount = -1 * cost
		end
	end
	
	log(log_id, "Cost: ", amount)

	cr = cr + amount
	
	if (cr < Reputation.MIN) then
		cr = Reputation.MIN
	end
	
	if (cr > Reputation.MAX) then
		cr = Reputation.MAX
	end
	
	Reputation[force] = cr
	
	log(log_id, "New reputation:", cr)
	
	if (resonance == false) then
		log(log_id, "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
--		updateForces()
		return
	end
	
	log(log_id, "Resonating...")
	
	local process = function(iforce, relation)
		if (iforce ~= PLAYER) then
			local icr = Reputation[iforce]
			local iamount = 0
			local player_rel = checkRelations(iforce, PLAYER)
			
			log(log_id, "=>", iforce, "is", relation, "to", force)
			log(log_id, "=>", "Current reputation with", iforce, "is", icr)
			log(log_id, "=>", iforce, "is", player_rel, "to Player")
			
			if (relation == ENEMY) then
				if (player_rel == ALLY) then
					iamount = cost * 2
				elseif (player_rel == NEUTRAL) then
					iamount = cost*1.5
				else
					iamount = cost
				end
			elseif (relation == ALLY) then
				if (player_rel == ALLY) then
					iamount = -0.5 * cost
				elseif (player_rel == NEUTRAL) then
					iamount = -1.5 * cost
				else
					iamount = -2 * cost
				end
			end
			
			log(log_id, "=>", "Cost:", iamount)
	
			icr = icr + iamount
			
			if (icr > Reputation.MAX) then
				icr = Reputation.MAX
			end
			
			if (icr < Reputation.MIN) then
				icr = Reputation.MIN
			end
			
			Reputation[iforce] = icr
			
			log(log_id, "=>", "New reputation with", iforce, "is", icr)
		end
	end
	
	table.foreach(Forces[force], process)
	
	log(log_id, "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
	
--	updateForces()
end

